﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

namespace Procesy
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            try
            {
                //Tytuł okna
                Text = "Lista procesów na " + System.Environment.MachineName;

                //Pobieranie i wyświetlanie listy uruchomionych procesów
                Process[] procesy = Process.GetProcesses();
                foreach (Process proces in procesy)
                {
                    if (proces.Id == 0) continue; //Proces bezczynności systemu
                    string opis = "" + proces.Id + "\t" + proces.BasePriority + "\t";
                    if (System.Environment.OSVersion.Version.Major < 6) opis += proces.StartTime + "\t" + proces.TotalProcessorTime + "\t"; //odmowa dostepu w Windows Vista i Windows 7
                    opis += proces.Threads.Count + "\t";
                    string tytul = proces.MainWindowTitle;
                    opis += ((tytul == "") ? proces.ProcessName.ToUpper() : tytul);
                    listBox1.Items.Add(opis);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd: " + ex.Message, "Procesy", MessageBoxButtons.OK, MessageBoxIcon.Error);
                throw ex; //obiekt okna nie powstanie
            }
        }
    }
}
